/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.io.*;

import ipipan.poliqarp.connection.PoliqarpConnection;

/**
 * A single interpretation of a segment.
 */
public final class Interpretation
{
   private String lemma;
   private String tag;

   /**
    * Constructs an <code>Interpretation</code> with given lemma and tags.
    * @param lemma lemma of the segment under this interpretation
    * @param tag tag of the segment under this interpretation
    */
   Interpretation(String lemma, String tag)
   {
      this.lemma = lemma;
      this.tag = tag;
   }

   /**
    * Constructs an <code>Interpretation</code>, reading its description from
    * a connection.
    *
    * @param connection the connection to read the interpretation from
    * @throws IOException if an I/O exception occurred while reading from
    * connection
    */
   Interpretation(PoliqarpConnection connection) throws IOException
   {
      lemma = connection.getStrMessage();
      tag = connection.getStrMessage();
   }
   
   /**
    * Returns the lemma of the segment under this interpretation.
    */
   public String getLemma() 
   {
      return lemma;
   }

   /**
    * Returns the tag of the segment under this interpretation.
    */
   public String getTag()
   {
      return tag;
   }

   /**
    * Returns this interpretation as a string.
    */
   public String toString(boolean dlemma, boolean dtag)
   {
      if (dlemma && !dtag)
         return "[" + lemma + "]";
      else if (dtag && !dlemma) 
         return "[" + tag + "]";
      else
         return "[" + lemma + ":" + tag + "]";
   }
}
