/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.PoliqarpConnection;

/**
 * A metadata value representing a date.
 */
public class MetaDataValueDate extends MetaDataValue
{
   private int year, month, day;
   
   /**
    * Constructs this value from its string description.
    * @param description description of the value
    */
   public MetaDataValueDate(String description)
   {
      super(description);
      String[] parts = description.split(" ");
      year = Integer.parseInt(parts[0]);
      month = Integer.parseInt(parts[1]);
      day = Integer.parseInt(parts[2]);
   }
      
   /**
    * Returns the representation of this metadata value as a string.
    * A locale can be helpful when converting several types of data
    * to strings, so this method takes one as a parameter.
    */
   public String toString(Locale locale)
   {
      if (month == 0 && day == 0)
         return "" + year;
      if (day == 0) {
         SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
         return df.format(new GregorianCalendar(year, month - 1, 1).getTime());
      }
      DateFormat df = DateFormat.getDateInstance(DateFormat.LONG,
         locale);
      return df.format(new GregorianCalendar(year, month - 1, day).getTime());
   }
}
