/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.io.IOException;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.connection.Message;

/**
 * A wide context for a query result.
 */
public final class WideContext
{
   private String leftContext, leftMatch, rightMatch, rightContext;

   /**
    * Reads the description of this context from a connection.
    */
   WideContext(PoliqarpConnection connection, int index) 
      throws IOException, QueryException
   {
      connection.send("GET-CONTEXT " + index);
      if (!connection.getMessage().isOK())
         throw new QueryException();
      leftContext = connection.getMessage().toString();
      leftMatch = connection.getMessage().toString();
      rightMatch = connection.getMessage().toString();
      rightContext = connection.getMessage().toString();
   }

   /**
    * Returns this context as a String.
    */
   public String toString()
   {
      return leftContext + leftMatch + rightMatch + rightContext;
   }

   private String htmlize(String s) 
   {
      return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
   }

   /**
    * Returns this context as a HTML-ized string. Similar to
    * <code>toString()<code>, except that the match part is
    * bold and rendered in color.
    */
   public String toHTML()
   {
      return htmlize(leftContext) 
         + "<span style=\"color: #000066; font-weight: bold\">" 
         + htmlize(leftMatch + rightMatch) + "</span>" + htmlize(rightContext);
   }
}
