/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic.results;

import ipipan.poliqarp.logic.*;
import ipipan.poliqarp.connection.PoliqarpConnection;

public class MatchCell extends ResultCell
{
   private Segment[] segments;
   private MatchColumn kind;

   public MatchCell(MatchColumn column, PoliqarpConnection connection)
      throws java.io.IOException
   {
      kind = column;
      int num = Integer.parseInt(connection.getStrMessage());
      segments = new Segment[num];
      for (int i = 0; i < num; i++) 
         segments[i] = new Segment(connection);
   }

   public boolean isConfigBoolSet(IConfiguration cfg, String key)
   {
      return cfg.getConfigItem(key).equals("yes");
   }
   
   public String toString(IConfiguration cfg, boolean html)
   {
      boolean displayOrth, displayBase, displayTag, bold = true;
      if (kind instanceof ColumnLeftContext ||
         kind instanceof ColumnRightContext)
      {
         displayOrth = isConfigBoolSet(cfg, "display-orth-context");
         displayBase = isConfigBoolSet(cfg, "display-base-context");
         displayTag = isConfigBoolSet(cfg, "display-tag-context");
         bold = false;
      } else {
         displayOrth = isConfigBoolSet(cfg, "display-orth");
         displayBase = isConfigBoolSet(cfg, "display-base");
         displayTag = isConfigBoolSet(cfg, "display-tag");
      }
      StringBuilder buf = new StringBuilder();
      for (Segment s : segments) 
         buf.append(html 
            ? s.toHTML(displayOrth, displayBase, displayTag, bold)
            : s.toString(displayOrth, displayBase, displayTag));
      return buf.toString();
   }

   public Segment[] getSegments() {
      return segments;
   }

   public String toString(IConfiguration cfg)
   {
      return toString(cfg, false);
   }
   
   public String toHTML(IConfiguration cfg) 
   {
      return toString(cfg, true);
   }
}
