package ipipan.poliqarp.stat;

public class CTest {
   static final int CP    = 1;
   static final int SCP   = 2;
   static final int MAXCP = 3;
   static final int DICE  = 4;

   int type;
   double bias = 0;

   int getType(String s) {
      if (s.equalsIgnoreCase("cp"))
         return CP;

      if (s.equalsIgnoreCase("scp"))
         return SCP;

      if (s.equalsIgnoreCase("maxcp"))
         return MAXCP;

      if (s.equalsIgnoreCase("dice"))
         return DICE;

      return 0;
   }

   public CTest(String s) {
      int i = s.indexOf(" bias ");

      if (i != -1) {
         bias = Util.safeParseFloat(s.substring(i + 6));
         s = s.substring(0, i);
      }

      type = getType(s);
   }

   public float calc(float c1, float c2, float c) {
      double res;

      switch (type) {
         case CP:
            res = c / c1;
            break;

         case SCP:
            res = c * c / (c1 * c2);
            break;

         case MAXCP:
            res = c1 > c2 ? c / c2 : c / c1;
            break;

         case DICE:
            res = (c + c) / (c1 + c2);
            break;

         default:
            return 0;

      }

      if (bias == 0)
         return (float) res;
      else
         return (float) (res * Math.pow(c, bias));
   }
}




