/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.stat;

import java.util.Iterator;

import ipipan.poliqarp.logic.Match;

/**
 * Iterator over all results of a statistical query.
 *
 * The iterator requires a MatchCounter to do the counting and
 * sorting beforehand - not sure if it can be done better.
 */
public final class StatIterator implements Iterator<Match>
{
   int number, count;
   MatchCounter counter;

   public StatIterator(MatchCounter c)
   {
      counter = c;
      count = c.count();
      number = 0;
   }

   /**
    * Answers whether there are matches left in this iterator.
    */
   public boolean hasNext()
   {
      return number < count;
   }

   /**
    * Returns the next match.
    */
   public Match next() {
      Match res = counter.getCells(number);
      number ++;
      return res;
   }

   /**
    * Always throws <code>UnsupportedOperationException</code>, since this
    * iterator doesn't support removing elements.
    */
   public void remove() throws UnsupportedOperationException
   {
      throw new UnsupportedOperationException();
   }
}
