package pl.waw.ipipan.corpcor.client;

import pl.waw.ipipan.corpcor.client.activity.MenuActivity;
import pl.waw.ipipan.corpcor.client.place.SearchPlace;
import pl.waw.ipipan.corpcor.client.view.MainPanel;

import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.ResettableEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.web.bindery.event.shared.EventBus;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class CorpCor implements EntryPoint {
private Place defaultPlace = new SearchPlace(null);
	
	public void onModuleLoad() {
		final MainPanel mainPanel = new MainPanel();
		RootLayoutPanel.get().add(mainPanel);

		ClientFactory clientFactory = GWT.create(ClientFactory.class);
		EventBus eventBus = clientFactory.getEventBus();
		PlaceController placeController = clientFactory.getPlaceController();
		
		// Menu
		MenuActivity menuActivity = new MenuActivity(clientFactory);
		menuActivity.start(mainPanel.getMenuPanel(), new ResettableEventBus(eventBus));
		
		// Master
		ActivityMapper masterActivityMapper = new MasterActivityMapper(clientFactory);
		ActivityManager masterActivityManager = new ActivityManager(masterActivityMapper, eventBus);

		masterActivityManager.setDisplay(mainPanel.getMasterPanel());
		
		// Detail
		ActivityMapper detailActivityMapper = new DetailActivityMapper(clientFactory);
		ActivityManager detailActivityManager = new ActivityManager(detailActivityMapper, eventBus);

		detailActivityManager.setDisplay(mainPanel.getDetailPanel());		
		
		// Start PlaceHistoryHandler with our PlaceHistoryMapper
		AppPlaceHistoryMapper historyMapper = GWT.create(AppPlaceHistoryMapper.class);
		PlaceHistoryHandler historyHandler = new PlaceHistoryHandler(historyMapper);
		historyHandler.register(placeController, eventBus, defaultPlace);
		
		historyHandler.handleCurrentHistory();
	}
}
