package pl.waw.ipipan.corpcor.client;

import java.util.ArrayList;

import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusApiException;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusTextBlock;
import pl.waw.ipipan.corpcor.shared.corpusapi.TextBlockSegments;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpContext;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpException;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpMetaData;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("springGwtServices/corpCorService")
public interface CorpCorService extends RemoteService {
    
    PoliqarpResult getQueryResult(String query, PoliqarpResult.PQResultItemId resultItemStart) throws PoliqarpException;
    ResultsPage<PoliqarpResult> getQueryResults(String query, PoliqarpResult.PQViewItemId viewItemStart, int length,
            boolean loadFromCorpus, boolean loadModified) throws PoliqarpException;
    
    PoliqarpMetaData getPoliqarpMetaData(PoliqarpResult.PQResultItemId resultId) throws PoliqarpException;
    PoliqarpContext getPoliqarpWideContext(PoliqarpResult.PQResultItemId resultId) throws PoliqarpException;

    ResultsPage<String> getCorpusTextIds(String query, int start, int length) throws CorpusApiException;
	ResultsPage<CorpusTextBlock> getCorpusText(String id, int start, int length) throws CorpusApiException;
	TextBlockSegments getCorpusTextBlock(String textId, String blockId, int start, int length, boolean latestFromDB) throws CorpusApiException;
	CorpusSegment getCorpusSegment(String textId, String blockId, String id, boolean latestFromDB) throws CorpusApiException;
    ArrayList<CorpusSegment> getCorpusSegments(String query, PoliqarpResult.PQResultItemId resultId) throws CorpusApiException, PoliqarpException;
    ArrayList<CorpusSegment> getCorpusSegments(PoliqarpResult queryResult, PoliqarpMetaData meta,
            PoliqarpContext wideContext) throws CorpusApiException;
}
