package pl.waw.ipipan.corpcor.client;

import java.util.ArrayList;

import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusTextBlock;
import pl.waw.ipipan.corpcor.shared.corpusapi.TextBlockSegments;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpContext;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpMetaData;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

import com.google.gwt.user.client.rpc.AsyncCallback;

public interface CorpCorServiceAsync {
    
    void getQueryResult(String query, PoliqarpResult.PQResultItemId resultItemStart, AsyncCallback<PoliqarpResult> callback);
    void getQueryResults(String query, PoliqarpResult.PQViewItemId viewItemStart, int length, boolean loadFromCorpus,
            boolean loadModified, AsyncCallback<ResultsPage<PoliqarpResult>> callback);
    
    void getPoliqarpMetaData(PoliqarpResult.PQResultItemId resultId, AsyncCallback<PoliqarpMetaData> callback);
    void getPoliqarpWideContext(PoliqarpResult.PQResultItemId resultId, AsyncCallback<PoliqarpContext> callback);

    void getCorpusTextIds(String query, int start, int length, AsyncCallback<ResultsPage<String>> callback);
	void getCorpusText(String id, int start, int length, AsyncCallback<ResultsPage<CorpusTextBlock>> callback);
	void getCorpusTextBlock(String textId, String blockId, int start, int length, boolean latestFromDB, AsyncCallback<TextBlockSegments> callback);
	void getCorpusSegment(String textId, String blockId, String id, boolean latestFromDB, AsyncCallback<CorpusSegment> callback);
	void getCorpusSegments(PoliqarpResult queryResult, PoliqarpMetaData meta, PoliqarpContext wideContext,
            AsyncCallback<ArrayList<CorpusSegment>> callback);
    void getCorpusSegments(String query, PoliqarpResult.PQResultItemId resultId, AsyncCallback<ArrayList<CorpusSegment>> callback);
}
