package pl.waw.ipipan.corpcor.client;

import pl.waw.ipipan.corpcor.client.activity.BrowseActivity;
import pl.waw.ipipan.corpcor.client.activity.ChangesActivity;
import pl.waw.ipipan.corpcor.client.activity.SearchActivity;
import pl.waw.ipipan.corpcor.client.activity.TextBlockActivity;
import pl.waw.ipipan.corpcor.client.place.BrowsePlace;
import pl.waw.ipipan.corpcor.client.place.ChangesPlace;
import pl.waw.ipipan.corpcor.client.place.SearchPlace;
import pl.waw.ipipan.corpcor.client.place.TextBlockPlace;

import com.google.gwt.activity.shared.Activity;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.Place;

public class MasterActivityMapper implements ActivityMapper {

	private ClientFactory clientFactory;
	private Place lastPlace = null;
	private Activity lastActivity = null;

	public MasterActivityMapper(ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
	}

	@Override
	public Activity getActivity(Place place) {
		if (place instanceof SearchPlace) {
			if ((lastPlace instanceof SearchPlace) && 
					(((SearchPlace)lastPlace).equalFields((SearchPlace)place))) {
				return lastActivity;
			}
			lastActivity = new SearchActivity((SearchPlace)place, clientFactory);
		} else if (place instanceof BrowsePlace) {
			if ((lastPlace instanceof BrowsePlace) &&
					(((BrowsePlace)lastPlace).equalFields((BrowsePlace)place))) {
				return lastActivity;
			}
			lastActivity = new BrowseActivity((BrowsePlace)place, clientFactory);
		} else if (place instanceof TextBlockPlace) {
			if ((lastPlace instanceof TextBlockPlace) &&
					(((TextBlockPlace)lastPlace).equalFields((TextBlockPlace)place))) {
				return lastActivity;
			}
			lastActivity = new TextBlockActivity((TextBlockPlace)place, clientFactory);
		} else if (place instanceof ChangesPlace) {
			lastActivity = new ChangesActivity((ChangesPlace)place, clientFactory);
		} else {
			lastActivity = null;
		}
		lastPlace = place;
		
		return lastActivity;
	}

}
