package pl.waw.ipipan.corpcor.client.activity;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.CorpCorAsyncCallback;
import pl.waw.ipipan.corpcor.client.CorpCorServiceAsync;
import pl.waw.ipipan.corpcor.client.place.BrowsePlace;
import pl.waw.ipipan.corpcor.client.place.BrowseTextPlace;
import pl.waw.ipipan.corpcor.client.place.TextBlockPlace;
import pl.waw.ipipan.corpcor.client.view.BrowseView;
import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusTextBlock;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;

public class BrowseActivity extends AbstractActivity implements BrowseView.Presenter {

	private ClientFactory clientFactory;
	private BrowsePlace place;
	private CorpusTextsAsyncDataProvider dataProvider = new CorpusTextsAsyncDataProvider();

	public BrowseActivity(BrowsePlace place, ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
		this.place = place;
	}
	
	private class CorpusTextsAsyncDataProvider extends AsyncDataProvider<String> {

		@Override
		protected void onRangeChanged(final HasData<String> display) {
		    final Range range = display.getVisibleRange();
		    final int start = range.getStart();
	        final int length = range.getLength();
	        
	        // TODO: Ignored for now
	        // final ColumnSortList sortList = clientFactory.getSearchView().getColumnSortList();
	        CorpCorServiceAsync rpcService = clientFactory.getRpcService();
	        
	        rpcService.getCorpusTextIds(place.getQuery(), start, length, new CorpCorAsyncCallback<ResultsPage<String>>() {
				
				@Override
				public void onSuccess(ResultsPage<String> result) {
					updateRowData(start, result.getEntries());
					updateRowCount(result.getGlobalSize(), true);
				}
			});
	        
		}
	}
	
	@Override
	public void start(final AcceptsOneWidget panel, EventBus eventBus) {
		BrowseView loginView = clientFactory.getBrowseView();
		loginView.setPresenter(this);
		
		dataProvider.addDataDisplay(loginView.getTable());
		
		panel.setWidget(loginView.asWidget());
		
		loginView.getQuery().setText(place.getQuery());
	}
	
	@Override
	public void onStop() {
		for (HasData<String> display : dataProvider.getDataDisplays()) {
			dataProvider.removeDataDisplay(display);
		}
	}

	@Override
	public void onTextClicked(final String id) {
		clientFactory.getPlaceController().goTo(new BrowseTextPlace(place.getQuery(), id));
	}

	@Override
	public void onSendQueryButtonClicked() {
		BrowseView view = clientFactory.getBrowseView();
		clientFactory.getPlaceController().goTo(new BrowsePlace(view.getQuery().getText()));
	}

}
