package pl.waw.ipipan.corpcor.client.activity;

import java.util.ArrayList;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.CorpCorAsyncCallback;
import pl.waw.ipipan.corpcor.client.place.BrowseTextPlace;
import pl.waw.ipipan.corpcor.client.place.SearchDetailsPlace;
import pl.waw.ipipan.corpcor.client.place.TextBlockPlace;
import pl.waw.ipipan.corpcor.client.view.BrowseTextView;
import pl.waw.ipipan.corpcor.client.view.SearchDetailsView;
import pl.waw.ipipan.corpcor.shared.ResultsPage;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusTextBlock;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;

public class BrowseTextActivity extends AbstractActivity implements BrowseTextView.Presenter {
	private ClientFactory clientFactory;
	private BrowseTextPlace place;
	private CorpusTextBlocksAsyncDataProvider dataProvider = new CorpusTextBlocksAsyncDataProvider();

	public BrowseTextActivity(BrowseTextPlace place,
			ClientFactory clientFactory) {
		this.clientFactory = clientFactory;
		this.place = place;
	}
	
	private class CorpusTextBlocksAsyncDataProvider extends AsyncDataProvider<CorpusTextBlock> {

		@Override
		protected void onRangeChanged(HasData<CorpusTextBlock> display) {
			final Range range = display.getVisibleRange();
			final int start = range.getStart();
		    final int length = range.getLength();
		     
		    clientFactory.getRpcService().getCorpusText(place.getId(), start, length, new CorpCorAsyncCallback<ResultsPage<CorpusTextBlock>>() {
		    	@Override
				public void onSuccess(ResultsPage<CorpusTextBlock> result) {
		    		updateRowData(start, result.getEntries());
		    		updateRowCount(result.getGlobalSize(), true);
				}
			});
		}
		
	}
	
	@Override
	public void start(AcceptsOneWidget panel, EventBus eventBus) {
		final BrowseTextView view = clientFactory.getBrowseTextView();
		view.setPresenter(this);
		view.getDisplay().setVisibleRangeAndClearData(view.getDisplay().getVisibleRange(), true);
		
		dataProvider.addDataDisplay(view.getDisplay());
		
		panel.setWidget(view.asWidget());
	}

	@Override
	public void onStop() {
		for (HasData<CorpusTextBlock> display : dataProvider.getDataDisplays()) {
			dataProvider.removeDataDisplay(display);
		}
	}

	@Override
	public void onEditButtonClicked(CorpusTextBlock textBlock) {
		clientFactory.getPlaceController().goTo(new TextBlockPlace(textBlock.getId(), place.getId()));
	}

}
