package pl.waw.ipipan.corpcor.client.activity;

import pl.waw.ipipan.corpcor.client.ClientFactory;
import pl.waw.ipipan.corpcor.client.CorpCorAsyncCallback;
import pl.waw.ipipan.corpcor.client.place.BrowseTextPlace;
import pl.waw.ipipan.corpcor.client.place.EditSegmentMorphoPlace;
import pl.waw.ipipan.corpcor.client.place.TextBlockPlace;
import pl.waw.ipipan.corpcor.client.view.TextBlockView;
import pl.waw.ipipan.corpcor.shared.corpusapi.TextBlockSegments;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AcceptsOneWidget;

public class TextBlockActivity extends AbstractActivity implements TextBlockView.Presenter {

	private TextBlockPlace place;
	private ClientFactory clientFactory;
	private String prevBlockId;
	private String nextBlockId;

	public TextBlockActivity(TextBlockPlace place, ClientFactory clientFactory) {
		this.place = place;
		this.clientFactory = clientFactory;
	}

	@Override
	public void start(AcceptsOneWidget panel, EventBus eventBus) {
		final TextBlockView view = clientFactory.getTextBlockView();
		view.setPresenter(this);
		
		view.setPrevButtonEnabled(false);
		view.setNextButtonEnabled(false);
		
		retrieveData();
		
		panel.setWidget(view.asWidget());
	}

	private void retrieveData() {
		clientFactory.getRpcService().getCorpusTextBlock(place.getTextId(), 
				place.getId(), 0, -1, true, new CorpCorAsyncCallback<TextBlockSegments>() {
			
			@Override
			public void onSuccess(TextBlockSegments result) {
				clientFactory.getTextBlockView().setData(result.getSegments());
				
				prevBlockId = result.getPrevBlockId();
				nextBlockId = result.getNextBlockId();
				
				if (prevBlockId != null) {
					clientFactory.getTextBlockView().setPrevButtonEnabled(true);
				}
				if (nextBlockId != null) {
					clientFactory.getTextBlockView().setNextButtonEnabled(true);
				}
			}
			
		});
	}

	@Override
	public void onSegmentClicked(String id) {
		clientFactory.getPlaceController().goTo(new EditSegmentMorphoPlace(place.getTextId(), place.getId(), id));
	}

	@Override
	public void onGoLeftButtonClicked() {
		if (prevBlockId != null) {
			clientFactory.getPlaceController().goTo(new TextBlockPlace(prevBlockId, place.getTextId()));
		}
	}

	@Override
	public void onGoUpButtonClicked() {
		clientFactory.getPlaceController().goTo(new BrowseTextPlace(null, place.getTextId()));
	}

	@Override
	public void onGoRightButtonClicked() {
		if (nextBlockId != null) {
			clientFactory.getPlaceController().goTo(new TextBlockPlace(nextBlockId, place.getTextId()));
		}
	}

}
