package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class BrowsePlace extends Place {
	private String query;
	
	@Prefix("browse")
	public static class Tokenizer implements PlaceTokenizer<BrowsePlace> {

		@Override
		public BrowsePlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			return new BrowsePlace(paramMap.get("query"));
		}

		@Override
		public String getToken(BrowsePlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("query", place.getQuery());
			return TokenizerUtils.asString(map);
		}

	}

	public BrowsePlace(String query) {
		this.query = query;
	}

	public String getQuery() {
		return query;
	}

	public boolean equalFields(BrowsePlace obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		
		if (query == null) {
			if (obj.query != null)
				return false;
		} else if (!query.equals(obj.query))
			return false;
		
		return true;
	}

}
