package pl.waw.ipipan.corpcor.client.place;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.Prefix;

public class EditSegmentMorphoPlace extends TextBlockPlace {
	
	protected String segmentId;
	
	@Prefix("editMorpho")
	public static class Tokenizer implements PlaceTokenizer<EditSegmentMorphoPlace> {

		@Override
		public EditSegmentMorphoPlace getPlace(String token) {
			Map<String, String> paramMap = TokenizerUtils.asMap(token);
			return new EditSegmentMorphoPlace(paramMap.get("textId"), paramMap.get("id"), paramMap.get("segmentId"));
		}

		@Override
		public String getToken(EditSegmentMorphoPlace place) {
			Map<Object, Object> map = new HashMap<Object, Object>();
			map.put("id", place.getId());
			map.put("textId", place.getTextId());
			map.put("segmentId", place.getSegmentId());
			return TokenizerUtils.asString(map);
		}

	}
	
	public EditSegmentMorphoPlace(String textId, String id, String segmentId) {
		super(id, textId);
		this.segmentId = segmentId;
	}
	
	public String getSegmentId() {
		return segmentId;
	}

}
