package pl.waw.ipipan.corpcor.client.place;

import java.util.Map;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;

public class TokenizerUtils {
	public final static String NULL_STRING = "";
	public final static String KEY_VALUE_SEPARATOR = "\\=";
	public final static String PAIR_SEPARATOR = "\\&";

	public static Map<String, String> asMap(String token) {
		Splitter.MapSplitter mapSplitter = Splitter
				.on(PAIR_SEPARATOR)
				.withKeyValueSeparator(KEY_VALUE_SEPARATOR);
		
		return mapSplitter.split(token);
	}
	
	public static String asString(Map<Object, Object> map) {
		Joiner.MapJoiner mapJoiner = Joiner
				.on(PAIR_SEPARATOR)
				.withKeyValueSeparator(KEY_VALUE_SEPARATOR)
				.useForNull(NULL_STRING);
		
		return mapJoiner.join(map);
	}
}
