package pl.waw.ipipan.corpcor.client.view;

import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusTextBlock;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.IdentityColumn;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;

public class BrowseTextViewImpl extends Composite implements BrowseTextView {
	private static final int PAGE_SIZE = 20;
	
	private static BrowseTextViewImplUiBinder uiBinder = GWT
			.create(BrowseTextViewImplUiBinder.class);

	interface BrowseTextViewImplUiBinder extends
			UiBinder<Widget, BrowseTextViewImpl> {
	}

	private Presenter presenter;
	
	@UiField(provided=true) DataGrid<CorpusTextBlock> cellTable;
	@UiField SimplePager simplePager;

	public BrowseTextViewImpl() {
		initCellTable();
		
		initWidget(uiBinder.createAndBindUi(this));
		
		simplePager.setDisplay(cellTable);
	    simplePager.setPageSize(PAGE_SIZE);
	}

	private void initCellTable() {
		cellTable = new DataGrid<CorpusTextBlock>();
		
		IdentityColumn<CorpusTextBlock> entryColumn = 
				new IdentityColumn<CorpusTextBlock>(new TextBlockCell());
		Column<CorpusTextBlock, String> openColumn = 
				new Column<CorpusTextBlock, String>(new ButtonCell()) {

			@Override
			public String getValue(CorpusTextBlock object) {
				return "Otwórz";
			}
			
		};
		
		cellTable.addColumn(entryColumn, "Blok");
		cellTable.addColumn(openColumn, "Otwórz");
		cellTable.setColumnWidth(openColumn, 10, Unit.PCT);
		
		openColumn.setFieldUpdater(new FieldUpdater<CorpusTextBlock, String>() {
			
			@Override
			public void update(int index, CorpusTextBlock textBlock, String value) {
				if (presenter != null) {
					presenter.onEditButtonClicked(textBlock);
				}
				
			}
		});
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

	@Override
	public HasData<CorpusTextBlock> getDisplay() {
		return cellTable;
	}
	
}
