package pl.waw.ipipan.corpcor.client.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import pl.waw.ipipan.corpcor.shared.validation.MsdCtagRules;

import com.google.common.base.Splitter;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle.MultiWordSuggestion;
import com.google.gwt.user.client.ui.SuggestOracle;

public class MsdSuggestOracle extends SuggestOracle {

	private HasText ctag;

	public MsdSuggestOracle(HasText ctag) {
		this.ctag = ctag;
	}

	@Override
	public void requestSuggestions(Request request, Callback callback) {
		String c = ctag.getText();
		String m = request.getQuery();
		
		List<String> candidates = new ArrayList<String>();
		
		List<String> posAttrs = MsdCtagRules.posMap.get(c);
		if (posAttrs == null) {
			return;
		}
		
		Iterable<String> splitted = Splitter.on(":").split(m);
		int i = 0;
		Iterator<String> it = splitted.iterator();
		while (it.hasNext()) {
			String s = it.next();

			if (i >= posAttrs.size()) {
				return;
			}
			
			String posAttr = posAttrs.get(i); 
			if (posAttr.startsWith("[")) {
				posAttr = posAttr.substring(1, posAttr.length() - 1);
			}
			
			List<String> attrs = MsdCtagRules.attrMap.get(posAttr);
			if (!it.hasNext()) {
				for (String a : attrs) {
					candidates.add(a);
				}
			}
			i++;
		}
		
		callback.onSuggestionsReady(request, new Response(convertToSuggestions(candidates, m)));
	}

	private Collection<? extends Suggestion> convertToSuggestions(
			List<String> candidates, String m) {
		List<MultiWordSuggestion> suggestions = new ArrayList<MultiWordSuggestion>();
		
		String prefix = "";
		int idx = m.lastIndexOf(":");
		if (idx != -1) {
			prefix = m.substring(0, idx + 1);
		}
		
		for (String s : candidates) {
			suggestions.add(new MultiWordSuggestion(prefix + s, s));
		}
		
		return suggestions;
	}

}
