/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.client.view;

import java.util.ArrayList;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.view.client.HasData;

public interface SearchDetailsView {

    public interface Presenter {
        void onCancelButtonClicked(ClickEvent e);

        void onEditButtonClicked(ClickEvent e);

        void onSegmentClicked(CorpusSegment segment);
        
        void onSaveOne();
        
        void onSaveAll();
    }

    void setPresenter(Presenter presenter);

    IsWidget asWidget();

    void setContext(String text);

    void setMetadata(String text);

    void setResultSegments(ArrayList<CorpusSegment> segments);

    SimpleBeanEditorDriver<AnnotationProxy, ?> getEditorDriver();

    HasData<CorpusSegment> getSegmentsTable();

    TabLayoutPanel getTabLayout();

    void clear();
}
