package pl.waw.ipipan.corpcor.client.view;

import java.util.ArrayList;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.corpusapi.CorpusSegment;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;

public class SearchDetailsViewImpl extends Composite implements SearchDetailsView {

	private static EditCommentViewImplUiBinder uiBinder = GWT
			.create(EditCommentViewImplUiBinder.class);

	interface EditCommentViewImplUiBinder extends
        UiBinder<Widget, SearchDetailsViewImpl> {
	}
	
	interface Driver extends SimpleBeanEditorDriver<AnnotationProxy, SegmentEditor> {}
	
	private Presenter presenter;
	
	@UiField Label context;
	@UiField Label metadata;
    @UiField(provided=true) CellTable<CorpusSegment> segmentsTable;
    @UiField SegmentEditor segmentEditor;
    @UiField Button buttonSaveOne;
    @UiField Button buttonSaveAll;
    @UiField TabLayoutPanel tabLayout;
    private Driver editorDriver;

    public SearchDetailsViewImpl() {
	    initSegmentsTable();
		initWidget(uiBinder.createAndBindUi(this));
        editorDriver = GWT.create(Driver.class);
        editorDriver.initialize(segmentEditor);
	}
    
    @Override
    public void clear() {
        this.context.setText("");
        this.metadata.setText("");
        this.segmentsTable.setRowData(new ArrayList<CorpusSegment>(0));
        // TODO how to clear the editor and driver to initial state??
        editorDriver.initialize(segmentEditor);
        segmentEditor.base.asEditor().setValue("");
        segmentEditor.comment.asEditor().setValue("");
        segmentEditor.ctag.asEditor().setValue("");
        segmentEditor.msd.asEditor().setValue("");
        segmentEditor.orth.asEditor().setValue("");
    }

    @Override
    public Driver getEditorDriver() {
        return editorDriver;
    }
    
    @Override
    public TabLayoutPanel getTabLayout() {
        return this.tabLayout;
    }

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}
	
	@UiHandler("cancelButton")
	void onCancelButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onCancelButtonClicked(e);
		}
	}
	/*
	@UiHandler("editButton")
	void onEditButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onEditButtonClicked(e);
		}
	}*/

	@Override
	public void setContext(String text) {
		context.setText(text);
	}

    @Override
    public void setMetadata(String text) {
        metadata.setText(text);
    }
    
    @Override
    public void setResultSegments(ArrayList<CorpusSegment> segments) {
        segmentsTable.setPageSize(segments.size());
        segmentsTable.setRowData(0, segments);
        segmentsTable.setRowCount(segments.size(), true);
        if (segments.size() == 1) {
            segmentsTable.getSelectionModel().setSelected(segments.get(0), true);
        }
    }

    private void initSegmentsTable() {
        segmentsTable = new CellTable<CorpusSegment>();
        TextColumn<CorpusSegment> idCol = new TextColumn<CorpusSegment>() {
            @Override
            public String getValue(CorpusSegment object) {
                return object.getSegmentId();
            }
        };
        TextColumn<CorpusSegment> orthCol = new TextColumn<CorpusSegment>() {
            @Override
            public String getValue(CorpusSegment object) {
                return object.getOrth();
            }
        };
        TextColumn<CorpusSegment> baseCol = new TextColumn<CorpusSegment>() {
            @Override
            public String getValue(CorpusSegment object) {
                return object.getBase();
            }
        };
        TextColumn<CorpusSegment> msdCol = new TextColumn<CorpusSegment>() {
            @Override
            public String getValue(CorpusSegment object) {
                return object.getMsd();
            }
        };
        TextColumn<CorpusSegment> ctagCol = new TextColumn<CorpusSegment>() {
            @Override
            public String getValue(CorpusSegment object) {
                return object.getCtag();
            }
        };
        
        segmentsTable.addColumn(idCol, "Id");
        segmentsTable.addColumn(orthCol, "Forma ortograficzna");
        segmentsTable.addColumn(baseCol, "Forma bazowa");
        segmentsTable.addColumn(msdCol, "MSD");
        segmentsTable.addColumn(ctagCol, "CTAG");
        
        final SingleSelectionModel<CorpusSegment> selModel = new SingleSelectionModel<CorpusSegment>();
        segmentsTable.setSelectionModel(selModel);
        selModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler() {
            @Override
            public void onSelectionChange(SelectionChangeEvent event) {
                if (presenter != null) {
                    presenter.onSegmentClicked(selModel.getSelectedObject());
                }
            }
        });
    }
    
    @Override
    public HasData<CorpusSegment> getSegmentsTable() {
        return this.segmentsTable;
    }

    @UiHandler("buttonSaveOne")
    void onButtonSaveOne(ClickEvent event) {
        if (presenter != null) {
            presenter.onSaveOne();
        }
    }
    
    @UiHandler("buttonSaveAll")
    void onButtonSaveAll(ClickEvent event) {
        if (presenter != null) {
            presenter.onSaveAll();
        }
    }
}
