package pl.waw.ipipan.corpcor.client.view;

import pl.waw.ipipan.corpcor.shared.pq.PoliqarpResult;

import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.SimplePager.TextLocation;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;

public class SearchViewImpl extends Composite implements SearchView {

	private static final int PAGE_SIZE = 5;
	private static CommentsViewImplUiBinder uiBinder = GWT
			.create(CommentsViewImplUiBinder.class);

	interface CommentsViewImplUiBinder extends
			UiBinder<Widget, SearchViewImpl> {
	}
	
	@UiField(provided=true) DataGrid<PoliqarpResult> cellTable;
	@UiField(provided=true) SimplePager simplePager;
	
	@UiField TextBox queryBox;
	@UiField Button sendQueryButton;
	@UiField CheckBox cbShowModified;
		
	private Presenter presenter;
	private MultiSelectionModel<PoliqarpResult> selectionModel;
	private CheckboxCell selectAllCell = new CheckboxCell();

	public SearchViewImpl() {
		initCellTable();
		
		SimplePager.Resources resources = GWT.create(SimplePager.Resources.class);
		simplePager = new SimplePager(TextLocation.CENTER, resources , false, 1000, true);
		
		initWidget(uiBinder.createAndBindUi(this));
	    
		simplePager.setDisplay(cellTable);
	    simplePager.setPageSize(PAGE_SIZE);
	}
	
	@UiHandler("sendQueryButton")
	void onSendQueryButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onSendQueryButtonClicked();
		}
	}
	
	@UiHandler("editButton")
	void onEditSelectedButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onEditSelectedButtonClicked();
		}
	}
	
	@UiHandler("selectAllButton")
	void onSelectAllButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onSelectAllButtonClicked();
		}
	}
	
	@UiHandler("selectNoneButton")
	void onSelectNoneButtonClicked(ClickEvent e) {
		if (presenter != null) {
			presenter.onDeselectAllButtonClicked();
		}
	}
	
	@UiHandler("queryBox")
	void onQueryBoxKeyPressed(KeyDownEvent e) {
		if (presenter != null) {
			if (e.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
				presenter.onSendQueryButtonClicked();
			}
		}
	}
	
	private void initCellTable() {
		cellTable = new DataGrid<PoliqarpResult>();
		
		selectionModel = 
				new MultiSelectionModel<PoliqarpResult>(new ProvidesKey<PoliqarpResult>() {

					@Override
					public Object getKey(PoliqarpResult item) {
						return item.getEntryId().resultId.id;
					}
		});

		cellTable.setSelectionModel(selectionModel, 
				DefaultSelectionEventManager.<PoliqarpResult>createCheckboxManager(0));
		
		Column<PoliqarpResult, Boolean> selectedColumn = new Column<PoliqarpResult, Boolean>(
				new CheckboxCell()) {

			@Override
			public Boolean getValue(PoliqarpResult object) {
				return selectionModel.isSelected(object);
			}
			
		};
		TextColumn<PoliqarpResult> lContextColumn = new TextColumn<PoliqarpResult>() {
			@Override
			public String getValue(PoliqarpResult object) {
				return object.getLeftContext();
			}
		};
		TextColumn<PoliqarpResult> matchColumn = new TextColumn<PoliqarpResult>() {
			@Override
			public String getValue(PoliqarpResult pqr) {
                return pqr.getMatchAnnotated("wczytaj adnotacje", "brak adnotacji w bazie");
			}
		};
		matchColumn.getFieldUpdater();
		TextColumn<PoliqarpResult> rContextColumn = new TextColumn<PoliqarpResult>() {
			@Override
			public String getValue(PoliqarpResult object) {
				return object.getRightContext();
			}
		};	
		
		Header<Boolean> selectedHeader = new Header<Boolean>(selectAllCell) {
			@Override
			public Boolean getValue() {
				return false;
			}
		};
		selectedHeader.setUpdater(new ValueUpdater<Boolean>() {
			
			@Override
			public void update(Boolean value) {
				if (presenter != null) {
					if (value) {
						presenter.onSelectPageButtonClicked();
					} else {
						presenter.onDeselectPageButtonClicked();
					}
				}
			}
		});
		cellTable.addColumn(selectedColumn, selectedHeader);
		cellTable.addColumn(lContextColumn, "Lewy kontekst");
		cellTable.addColumn(matchColumn, "Dopasowanie");
		cellTable.addColumn(rContextColumn, "Prawy kontekst");
		
		cellTable.setColumnWidth(selectedColumn, 3, Unit.EM);
		
		cellTable.addCellPreviewHandler(new CellPreviewEvent.Handler<PoliqarpResult>() {

			@Override
			public void onCellPreview(CellPreviewEvent<PoliqarpResult> event) {
				if ((event.getColumn() != 0) && ("click".equals(event.getNativeEvent().getType()))) {
					if (presenter != null) {
						presenter.onResultClicked(event.getValue());
					}
				}
			}
		});
		
		//cellTable.addColumnSortHandler(new ColumnSortEvent.AsyncHandler(cellTable));
		
		Label emptyLabel = new Label("Nie znaleziono żadnych wyników dla bieżącego zapytania.");
		cellTable.setEmptyTableWidget(emptyLabel);
	}
	
	@Override
	public Widget asWidget() {
		return this;
	}

	@Override
	public void setPresenter(Presenter presenter) {
		this.presenter = presenter;
	}

	@Override
	public HasData<PoliqarpResult> getTable() {
		return cellTable;
	}

	@Override
	public ColumnSortList getColumnSortList() {
		return cellTable.getColumnSortList();
	}

	@Override
	public HasText getQuery() {
		return queryBox;
	}

	@Override
	public void setPageSelector(boolean allSelected) {
		selectAllCell.setViewData(false, allSelected);
	}
	
	@Override
	public boolean isShowModified() {
	    return this.cbShowModified.getValue().booleanValue();
	}
	
    @UiHandler("cbShowModified")
    void onCbShowModifiedClick(ClickEvent event) {
        refresh();
    }
    
    @Override
    public void refresh() {
        if (this.presenter != null) {
            this.presenter.reload();
        }
    }

	@Override
	public void setLoadingIndicator(boolean b) {
		if (b == true) {
			queryBox.setEnabled(false);
			sendQueryButton.setEnabled(false);
			sendQueryButton.setText("Czekaj...");
		} else {
			queryBox.setEnabled(true);
			sendQueryButton.setEnabled(true);
			sendQueryButton.setText("Szukaj");
		}
	}
}
