package pl.waw.ipipan.corpcor.client.view;

import pl.waw.ipipan.corpcor.shared.AnnotationProxy;
import pl.waw.ipipan.corpcor.shared.validation.MsdCtagRules;
import pl.waw.ipipan.corpcor.shared.validation.MsdCtagValidator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.ui.client.ValueBoxEditorDecorator;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;

public class SegmentEditor extends Composite implements Editor<AnnotationProxy> {

	private static SegmentEditorUiBinder uiBinder = GWT
			.create(SegmentEditorUiBinder.class);

	interface SegmentEditorUiBinder extends UiBinder<Widget, SegmentEditor> {
	}
	
	@UiField ValueBoxEditorDecorator<String> orth;
	@UiField ValueBoxEditorDecorator<String> base;
//	@UiField ValueBoxEditorDecorator<String> msd;
//	@UiField ValueBoxEditorDecorator<String> ctag;
	@UiField(provided=true) SuggestBox msd;
	@UiField(provided=true) SuggestBox ctag;
	@UiField TextArea comment;
	@UiField CheckBox deleted;

	public SegmentEditor() {
		MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
		oracle.addAll(MsdCtagRules.posMap.keySet());
		ctag = new SuggestBox(oracle);
		
		msd = new SuggestBox(new MsdSuggestOracle(ctag));
		
		initWidget(uiBinder.createAndBindUi(this));
	}
}
