package pl.waw.ipipan.corpcor.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import pl.waw.ipipan.corpcor.server.dao.AnnotationDao;
import pl.waw.ipipan.corpcor.server.model.Annotation;

import com.google.web.bindery.requestfactory.shared.Locator;

@Component
public class AnnotationLocator extends Locator<Annotation, Long> {
	@Autowired
	private AnnotationDao annotationDao;
	
	@Override
	public Annotation create(Class<? extends Annotation> clazz) {
		return new Annotation();
	}

	@Override
	public Annotation find(Class<? extends Annotation> clazz, Long id) {
		return annotationDao.findById(id);
	}

	@Override
	public Class<Annotation> getDomainType() {
		return Annotation.class;
	}

	@Override
	public Long getId(Annotation domainObject) {
		return domainObject.getId();
	}

	@Override
	public Class<Long> getIdType() {
		return Long.class;
	}

	@Override
	public Object getVersion(Annotation domainObject) {
		return domainObject.getVersion();
	}

}
