package pl.waw.ipipan.corpcor.server.corpusapi;


/**
 * @author Pharkas
 * Reprezentuje blok tekstu (<p>, <ab>, <u>, itd.)
 *
 */
public interface TextBlock {
	enum TextBlockType {P, AB, U};
	
	/**
	 * Zwraca następny blok z tekstu
	 * @return następny blok z tekstu lub null, jeśli nie ma
	 */
	public TextBlock getNext();
	
	/**
	 * Zwraca poprzedni blok z tekstu
	 * @return poprzedni blok z tekstu lub null, jeśli nie ma
	 */
	public TextBlock getPrev();
	
	/**
	 * Sprawdza, czy następny blok z tekstu należy do tego samego kontekstu
	 * @return true, jeśli znajduje się w tym samym znaczniku <div> (ten sam kontekst)
	 */
	public boolean isNextRelated();
	
	/**
	 * Sprawdza, czy poprzedni blok z tekstu należy do tego samego kontekstu
	 * @return true, jeśli znajduje się w tym samym znaczniku <div> (ten sam kontekst)
	 */
	public boolean isPrevRelated();
	
	/**
	 * Zwraca liczbę segmentów w bloku
	 * @return
	 */
	public int getSize();
	
	/**
	 * Zwraca segment na podanym indeksie lub null, jeśli nie ma
	 * @param idx indeks segmentu
	 * @return segment na wskazanym indeksie
	 * @throws Exception 
	 */
	public Segment getSegment(int idx) throws Exception;
	
	/**
	 * Zwraca grupę segmentów na podanej pozycji w bloku i o podanym typie
	 * lub null, jeśli takiej nie ma
	 * @param idx indeks segmentu
	 * @param type typ grupy segmentów (poziom anotacji)
	 * @return grupa segmentów
	 * @throws Exception 
	 */
	public SegmentGroup getSegmentGroup(int idx, Class<? extends SegmentGroup> type) throws Exception;
	
	/**
	 * Zwraca typ bloku z tekstu (<p>, <ab>, <u>)
	 * @return typ bloku z tekstu (<p>, <ab>, <u>)
	 */
	public TextBlockType getType();
	
	public CorpusText getCorpusText();
	
	/**
	 * Zwraca dlugosc bloku w sensie liczby znakow
	 * @return liczba znakow bloku
	 */
	public long getLength();
	
	public String getId();
}
