/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.io.Serializable;

public final class TEIBiblElement implements Serializable {
    final String element, type;

    public TEIBiblElement(String element) {
        this(element, null);
    }

    public TEIBiblElement(String element, String type) {
        if (element == null)
            throw new NullPointerException("element");
        this.element = element;
        this.type = type;
    }
    
    @Override
    public int hashCode() {
        return element.hashCode() ^ (((type != null) ? (type.hashCode() << 16 - 1): 0));
    }

    @Override
    public boolean equals(Object obj) {
        TEIBiblElement c = (TEIBiblElement) obj;
        return element.equals(c.element) && ((type != null && type.equals(c.type)) || (c.type == null));
    }

    @Override
    public String toString() {
        if (this.type == null)
            return this.element;
        return this.element + "/" + this.type;
    }
}