package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.stream.XMLStreamException;

import pl.waw.ipipan.corpcor.server.corpusapi.ContinueMode;
import pl.waw.ipipan.corpcor.server.corpusapi.MorphoSegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIMorphoReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIReader;


public class TEIMorphoSegmentGroup extends TEISegmentGroup implements MorphoSegmentGroup {
	
	private List<TEIMorphLex> interps;
	private TEIInterpretation interpChoice = null;
	
	public String orth;
	public String disambTool;
	public String disambResp;
	public String disambDate;
	public String disambChoice;
	
	public TEIMorphoSegmentGroup(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId) {
		super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
	}

	@Override
	public TEIMorphoSegmentGroup getNext(ContinueMode mode) {
		if (nextGroupId == null) return null;
		
		TEIMorphoSegmentGroup segmentGroup = null;
		try {
			TEIMorphoReader morphoReader = ((TEICorpus)corpusText.getCorpus()).getTEIMorphoReader(corpusText);
			segmentGroup = morphoReader.getMorphoSegmentGroupById(nextGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
		return (TEIMorphoSegmentGroup) getNeighbour(mode, this, segmentGroup, false);
	}

	@Override
	public TEIMorphoSegmentGroup getPrev(ContinueMode mode) {
		if (prevGroupId == null) return null;
		
		TEIMorphoSegmentGroup segmentGroup = null;
		try {
			TEIMorphoReader senseReader = ((TEICorpus)corpusText.getCorpus()).getTEIMorphoReader(corpusText);
			segmentGroup = senseReader.getMorphoSegmentGroupById(prevGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return (TEIMorphoSegmentGroup) getNeighbour(mode, segmentGroup, this, true);
	}
	
	@Override
	public String toString() {
		String r = "TEIMorpho   [id:"+id+", next:"+nextGroupId+", prev:"+prevGroupId+", segments:"+segmentIdList+",\n"+
			   "           orth:"+orth+",\n"+
			   "           tool:"+disambTool+",\n"+
			   "           resp:"+disambResp+",\n"+
			   "           date:"+disambDate+",\n"+
			   "         choice:"+getChosenInterpretation()+",\n"+
			   "        interps:";
		for (TEIInterpretation t : getAllInterpretations())
			   r += "\n           "+t;
		r += "]";
		return r;
	}
	
	public TEIInterpretation getChosenInterpretation() {
		if (interpChoice == null) {
			for (TEIMorphLex ml : interps) {
				if (ml.msd.containsKey(disambChoice)) {
					interpChoice = new TEIInterpretation(disambChoice, ml.base, ml.ctag, ml.msd.get(disambChoice));
					break;
				}
			}
		}
		return interpChoice;		
	}
	
	public List<TEIInterpretation> getAllInterpretations() {
		List<TEIInterpretation> result = new ArrayList<TEIInterpretation>();
		for (TEIMorphLex ml : interps) {
			for (Entry<String, String> entry: ml.msd.entrySet()) {				
				TEIInterpretation i = new TEIInterpretation(entry.getKey(), ml.base, ml.ctag, entry.getValue());
				result.add(i);
			}
		}
		return result;
	}

	public void setInterps(List<TEIMorphLex> interps) {
		this.interps = interps;
	}
}
