package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLStreamException;

import pl.waw.ipipan.corpcor.server.corpusapi.ContinueMode;
import pl.waw.ipipan.corpcor.server.corpusapi.MorphoSegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.Segment;
import pl.waw.ipipan.corpcor.server.corpusapi.SegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.SenseSegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.SentenceSegmentGroup;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIMorphoReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEIReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEISegmentationReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEISenseReader;
import pl.waw.ipipan.corpcor.server.corpusapi.tei.readers.TEITextReader;


public class TEISegment implements Segment {
	/** id segmentu */
	protected String segmentId;
	/** tekst korpusu, do którego należy segment */
	protected TEICorpusText corpusText;	
	
	/** id kolejnego segmentu */	
	protected String nextSegmentId;
	/** id poprzedniego segmentu */
	protected String prevSegmentId;

	/** id bloku tekstu, w ktorym jest segment (z pliku segmentation.xml) */
	protected String textBlockId = null;
	/** id zdania, w którym jest segment (z pliku segmentation.xml) */
	protected String sentenceId = null;
	/** id znacznika p, w którym jest segment (z pliku segmentation.xml) */
	protected String pId;
	
	/** pozycja początku segmentu wewnątrz bloku tekstu (z pliku text.xml) */
	protected int startIdx;
	/** pozycja końca segmentu wewnątrz bloku tekstu (z pliku text.xml) */
	protected int endIdx;
	/** indeks segmentu w bloku tekstu */
	protected int segmentPosition;

	/** forma ortograficzna segmentu (z pliku text.xml) */
	protected String orth = null;
	/** blok tekstu, do którego należy segment */
	protected TEITextBlock textBlock = null;

	
	public TEISegment(String segmentId, TEICorpusText corpusText, String nextSegmentId, 
			String prevSegmentId, String textBlockId, String sentenceId, int startIdx, int endIdx, int segmentPosition, String pId, String resultOrth) {
		this.segmentId = segmentId;
		this.corpusText = corpusText;
		
		this.nextSegmentId = nextSegmentId;
		this.prevSegmentId = prevSegmentId;
		
		this.textBlockId = textBlockId;
		this.sentenceId = sentenceId;
		
		this.endIdx = endIdx;
		this.startIdx = startIdx;
		this.segmentPosition = segmentPosition;
		
		this.pId = pId;
		this.orth = resultOrth;
	}

	@Override
	public TEISegmentGroup getFirstSegmentGroup(int dir, Class<? extends SegmentGroup> type, ContinueMode mode) throws Exception {
		TEISegmentGroup currentSegmentGroup = getSegmentGroup(type);
		if (currentSegmentGroup == null) {			
			if (dir > 0) {
				TEISegment s = getNext(mode);
				while (s != null) {
					TEISegmentGroup segmentGroup = s.getSegmentGroup(type);
					if (segmentGroup != null) {
						return segmentGroup;
					}
					s = s.getNext(mode);
				}								
			} else if (dir < 0) {
				TEISegment s = getPrev(mode);
				while (s != null) {
					TEISegmentGroup segmentGroup = s.getSegmentGroup(type);
					if (segmentGroup != null) {
						return segmentGroup;
					}
					s = s.getPrev(mode);
				}			
			}
		} else {
			if (dir > 0) {
				return currentSegmentGroup.getNext(mode);					
			} else if (dir < 0) {
				return currentSegmentGroup.getPrev(mode);
			}			
		}
		return null;
	}

	@Override
	public TEISegment getNeighbor(int dist) throws Exception {
		return getNeighbor(dist, ContinueMode.ALWAYS_STOP);
	}

	@Override
	public TEISegment getNeighbor(int dist, ContinueMode mode) throws Exception {
		int newIdx = segmentPosition + dist;
		
		TEITextBlock blockWithSegment = getTextBlock();
				
		// szukany segment jest w ktoryms z kolejnych blokow
		while (newIdx + 1 > blockWithSegment.getSize()) {
			
			if (mode.equals(ContinueMode.ALWAYS_STOP)) {
				return null;
			} else if (mode.equals(ContinueMode.CONTINUOUS)) {
				if (!blockWithSegment.isNextRelated()) {
					return null;
				}				
			}
			
			newIdx = newIdx - blockWithSegment.getSize();			
			blockWithSegment = blockWithSegment.getNext();
			if (blockWithSegment == null) return null;
		} 
		
		// szukany segment jest w ktoryms z poprzednich blokow
		while (newIdx < 0) {
			
			if (mode.equals(ContinueMode.ALWAYS_STOP)) {
				return null;
			} else if (mode.equals(ContinueMode.CONTINUOUS)) {
				if (!blockWithSegment.isPrevRelated()) {
					return null;
				}				
			}
						
			blockWithSegment = blockWithSegment.getPrev();
			if (blockWithSegment == null) return null;
			newIdx = blockWithSegment.getSize() + newIdx;
		}
		
		return blockWithSegment.getSegment(newIdx);
	}

	@Override
	public TEISegment getNext() throws Exception {
		return getNext(ContinueMode.ALWAYS_CONTINUE);
	}

	@Override
	public TEISegment getNext(ContinueMode mode) throws Exception {
		if (nextSegmentId == null) return null;

		//pobieranie kolejnego segmentu
		TEISegment nextSegment = null;

		TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
		nextSegment = segmentationReader.getSegmentById(nextSegmentId);
		
		if (mode.equals(ContinueMode.ALWAYS_STOP)) {
			if (!this.getTextBlock().equals(nextSegment.getTextBlock())) {
				return null;
			}
		} else if (mode.equals(ContinueMode.CONTINUOUS)) {
			if (!this.isRelatedToSuccessor(nextSegment)) {
				return null;
			}
		}
		 
		return nextSegment;
	}

	@Override
	public TEISegment getPrev() throws Exception {
		return getPrev(ContinueMode.ALWAYS_CONTINUE);
	}

	@Override
	public TEISegment getPrev(ContinueMode mode) throws Exception {
		if (prevSegmentId == null) return null;

		//pobieranie kolejnego segmentu
		TEISegment prevSegment = null;
		TEISegmentationReader segmentationReader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
		prevSegment = segmentationReader.getSegmentById(prevSegmentId);
		
		if (mode.equals(ContinueMode.ALWAYS_STOP)) {
			if (!this.getTextBlock().equals(prevSegment.getTextBlock())) {
				return null;
			}
		} else if (mode.equals(ContinueMode.CONTINUOUS)) {
			if (!prevSegment.isRelatedToSuccessor(this)) {
				return null;
			}
		}
		 
		return prevSegment;
	}

	@Override
	public int getPosition() {
		return segmentPosition;
	}
	
	@Override
	public TEISegmentGroup getSegmentGroup(Class<? extends SegmentGroup> type) {		
		if (type.equals(SentenceSegmentGroup.class) || type.equals(TEISentenceSegmentGroup.class)) {			
			try {
				TEISegmentationReader reader = ((TEICorpus)corpusText.getCorpus()).getTEISegmentationReader(corpusText);
				return reader.getSentenceSegmentGroupById(sentenceId);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (type.equals(SenseSegmentGroup.class) || type.equals(TEISenseSegmentGroup.class)) {
			TEISenseReader reader = ((TEICorpus)corpusText.getCorpus()).getTEISenseReader(corpusText);
			try {
				return reader.getSenseSegmentGroupBySegmentId(segmentId);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (FileNotFoundException e) {
				System.out.println(e.getMessage());
//				System.out.println("Senses file not found");//+this.getTextBlock().getCorpusText().getSensesFilePath());
				return null;
			} catch (IOException e) {				
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			}
		} else if (type.equals(MorphoSegmentGroup.class) || type.equals(TEIMorphoSegmentGroup.class)) {
			TEIMorphoReader reader = ((TEICorpus)corpusText.getCorpus()).getTEIMorphoReader(corpusText);
			try {
				return reader.getMorphoSegmentGroupBySegmentId(segmentId);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
//				System.out.println("Error reading file: "+getTextBlock().getCorpusText().getSensesFilePath());
				e.printStackTrace();
				return null;
			}
		}

		return null;
	}

	@Override
	public List<SegmentGroup> getSegmentGroups() {
		List<SegmentGroup> l = new ArrayList<SegmentGroup>();

		// todo : skad brac typy?
		List<Class<? extends TEISegmentGroup>> types = new ArrayList<Class<? extends TEISegmentGroup>>();
		types.add(TEISenseSegmentGroup.class);
		types.add(TEIMorphoSegmentGroup.class);
		types.add(TEISentenceSegmentGroup.class);
																													// poprawki
		for (Class<? extends TEISegmentGroup> type : types) {
			TEISegmentGroup s = getSegmentGroup(type);
			if (s != null) {
				l.add(s);
			}
		}
		return l;
	}

	@Override
	public TEITextBlock getTextBlock() {		
		if (textBlock == null) {
			try {
				TEITextReader reader = ((TEICorpus)corpusText.getCorpus()).getTEITextReader(corpusText);
				textBlock = reader.getTextBlockById(textBlockId);
			} catch (XMLStreamException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return textBlock;
	}

	@Override
	public String toString() {
		return "TEISegment [orth=" + getOrth() + ", indx="+segmentPosition+", seg.id=" + segmentId + 
		", nextSegment="+nextSegmentId+", prevSegment="+prevSegmentId+", sentence.id = "+ sentenceId +
		", textblockId="+textBlockId+"]";
	}

	@Override
	public String getOrth() {
		if (orth == null) {
			/*
			try {
				TEITextReader textReader = ((TEICorpus)corpusText.getCorpus()).getTEITextReader(corpusText);				
				Reader reader = textReader.getTextReaderForOrth();
				reader.reset();
				reader.skip(getTextBlock().filePosition + startIdx);

				char buf[] = new char[endIdx - startIdx];
				int length = buf.length;

				int read_chars = reader.read(buf, 0, length);
				if (read_chars == length) {
					return new String(buf, 0, length);
				} else {
					return null;
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}*/
			
			TEIMorphoSegmentGroup tmsg = (TEIMorphoSegmentGroup) getSegmentGroup(MorphoSegmentGroup.class);
			if (tmsg != null) {
				orth = tmsg.orth;
			}
		}
		return orth;
	}

	public boolean isRelatedToSuccessor(TEISegment successor) {
		return (this.getPId().equals(successor.getPId()));
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result	+ ((corpusText == null) ? 0 : corpusText.hashCode());
		result = prime * result	+ ((segmentId == null) ? 0 : segmentId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TEISegment other = (TEISegment) obj;
		if (corpusText == null) {
			if (other.corpusText != null)
				return false;
		} else if (!corpusText.equals(other.corpusText))
			return false;
		if (segmentId == null) {
			if (other.segmentId != null)
				return false;
		} else if (!segmentId.equals(other.segmentId))
			return false;
		return true;
	}

	@Override
	public String getId() {
		return segmentId;
	}

	public int getEndIdx() {
		return endIdx;
	}

	public int getStartIdx() {
		return startIdx;
	}

	public int getSegmentPosition() {
		return segmentPosition;
	}

	public String getNextSegmentId() {
		return nextSegmentId;
	}

	public String getTextBlockId() {
		return textBlockId;
	}

	public String getSentenceId() {
		return sentenceId;
	}
	
	public String getPId() {
		return pId;
	}
}
