package pl.waw.ipipan.corpcor.server.corpusapi.tei;

import java.util.List;
import java.util.Vector;

import pl.waw.ipipan.corpcor.server.corpusapi.Sense;
import pl.waw.ipipan.corpcor.server.corpusapi.util.MultiSelection;


/**
 * podsensy nie posiadaja id (null). sensy obu poziomów posiadają 'identyfikator' n
 * 
 * 
 * @author Rafał Młodzki
 *
 */
public class TEISense implements Sense {
	
	private MultiSelection definition = null; //pytanie czy nie powinno byc klasy definicja, bo tam jest jakas struktura (tj. podkreslanie slowa)
	private String senseID = null; //w subsensach ma to byc null?
	
	private TEISense coarserSense; //sens nadrzedny, rodzic
	
	private int n; //tajemnicze n
	
	private int coarseLevel;
	
	private List<MultiSelection> quotes;
	private List<TEISense> subsenses;
	
	public void setDefinition(MultiSelection definition) {
		this.definition = definition;		
	}

	public TEISense(String senseID, TEISense coarserSense, int coarseLevel) {
		super();
		this.senseID = senseID;
		this.subsenses = new Vector<TEISense>(); //moze lepiej null, bo po co marnowac na podpodsensy?
		this.coarseLevel = coarseLevel;
		this.coarserSense = coarserSense;
		this.quotes = new Vector<MultiSelection>();		
	}


	public void addSense(TEISense sense) {
		this.subsenses.add(sense);
	}
	
	public void addQuote(MultiSelection quote) {
		this.quotes.add(quote);
	}
	
	
	@Override
	public String toString() {
		StringBuilder sb =  new StringBuilder();
		sb.append("   def: "+getMultiDefinition()+"("+getId()+" n: "+getN()+")"+"\n");
		List<TEISense> subsenses = getSubSenses();
		for (TEISense subsense : subsenses) {
			sb.append("       def: "+subsense.getMultiDefinition()+"(n: "+getN()+")\n");
			List<String> quotes = subsense.getQuotes();
			for (String quote : quotes) {
				sb.append("           quo: "+quote+"\n");
			}
		}
		return sb.toString()  ;
		
	}


	@Override
	public TEISenseEntry getSenseEntry() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDefinition() {
		return definition.toString();
	}
	
	/**
	 * zwraca definicje multiselekcje
	 * @return
	 */
	public MultiSelection getMultiDefinition() {
		return definition;
	}

	@Override
	public String getId() {
		return senseID;
	}

	@Override
	public List<TEISense> getSubSenses() {
		return subsenses;
	}
	
	@Override
	public List<String> getQuotes() {
		List<String> qs = new Vector<String>();
		for (MultiSelection quote : quotes) {
			String stringQuote = quote.toString();
			if ((stringQuote != null) && (stringQuote.length() > 0)) {
				qs.add(quote.toString());
			}
		}
		
		return qs;
	}

	public List<MultiSelection> getMultiQuotes() {
		return quotes;
	}
	
	@Override
	public Sense getCoarserSense() {
		return this.coarserSense;
	}
	
	public int getN() {
		return n;
	}

	public void setN(int n) {
		this.n = n;
	}

	@Override
	public int getCoarseness() {
		return coarseLevel;
	}

	@Override
	public List<String> getAllQuotes() {
		List<String> qs = getQuotes();
		
		for (TEISense subsense : subsenses) {
			qs.addAll(subsense.getAllQuotes());
		}
		
		return qs;
	}
	/**
	 * zwraca listę przykladow (takze z pod sensow) w postaci multiselekcji
	 * @return
	 */
	public List<MultiSelection> getAllMultiQuotes() {
		List<MultiSelection> qs = new Vector<MultiSelection>();
		qs.addAll(quotes);
		for (TEISense subsense : subsenses) {
			qs.addAll(subsense.getAllMultiQuotes());
		}
		return qs;
	}

	@Override
	public List<String> getDefinitions() {
		List<String> defs = new Vector<String>();
		defs.add(definition.toString());
		for (TEISense subsense : subsenses) {
			defs.addAll(subsense.getDefinitions());
		}
		return defs;
	}
	
	public List<MultiSelection> getMultiDefinitions() {
		List<MultiSelection> defs = new Vector<MultiSelection>();
		defs.add(definition);
		for (TEISense subsense : subsenses) {
			defs.addAll(subsense.getMultiDefinitions());
		}
		return defs;
	}

	
	
	
}
