/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.corpusapi.tei.pq;

import java.util.HashMap;
import java.util.Map;

import pl.waw.ipipan.corpcor.server.corpusapi.tei.TEIBiblElement;

public final class TEItoPQMetadata {

    private static final Map<String, TEIBiblElement> PQtoTEImetaMapping = new HashMap<String, TEIBiblElement>();
    static {
        PQtoTEImetaMapping.put("miejsce_wydania", new TEIBiblElement("pubPlace"));
        PQtoTEImetaMapping.put("wydawca", new TEIBiblElement("publisher"));
        PQtoTEImetaMapping.put("autor", new TEIBiblElement("author"));
        PQtoTEImetaMapping.put("tytuł", new TEIBiblElement("title"));
        PQtoTEImetaMapping.put("data_wydania", new TEIBiblElement("date", "published"));
        PQtoTEImetaMapping.put("ISBN", new TEIBiblElement("idno", "ISBN"));
        PQtoTEImetaMapping.put("nkjp", new TEIBiblElement("idno", "nkjp"));
    }
    
    public static TEIBiblElement getForPQMetadata(String key) {
        if (PQtoTEImetaMapping.containsKey(key)) {
            return PQtoTEImetaMapping.get(key);
        }
        return null;
    }
}