package pl.waw.ipipan.corpcor.server.corpusapi.util;

import java.awt.Point;
import java.util.Vector;



/**
 * służy do przechowania cytatów i definicji ze słownika TEI, gdzie słowo kluczowe może występować parokrotnie. 
 * @author Project Manager
 *
 */
public class MultiSelection {

	private StringBuilder sb;
	private Vector<Point> selections; 
	
	
	public MultiSelection() {
		sb =  new StringBuilder();
		selections =  new Vector<Point>();
	}
	
	
	public void addText(String text,boolean isSelected) {
		if (isSelected) {
			selections.add(new Point(sb.length(),sb.length()+text.length()));
		}
		sb.append(text);
	}
	
	public int getNumberOfSelections() {
		return selections.size();
	}
	
	/**
	 * wez i-tą selekcje (tzn. stworz taki leftkeyright, ze key to i-ta selekcja
	 * @param i
	 * @return
	 */
	
	public LeftKeyRight get(int i) {
		return new LeftKeyRight(sb.substring(0, selections.get(i).x),
								sb.substring(selections.get(i).x, selections.get(i).y),
								sb.substring(selections.get(i).y));
	}	
	
	@Override
	public String toString() {
		return sb.toString();
	}
	
	/**
	 * wystapieniom selekcji zamieniane sa litery w wielkie litery 
	 */
	public String toUppercasedString() {
		StringBuilder sbtmp = new StringBuilder(sb);
		for (Point selection : selections) {
			sbtmp.replace(selection.x, selection.y, sb.substring(selection.x,selection.y).toUpperCase());
		}
		return sbtmp.toString();
	}
	
	public static void main(String[] args) {
		MultiSelection ms =  new MultiSelection();
		ms.addText("Rafał ", false);
		ms.addText("pisze", true);
		ms.addText(" sobie powolutku ", false);
		ms.addText("programik", true);
		System.out.println("'"+ms.get(0).keyword+"'");
		System.out.println(ms);
		
	}
	
}
