/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import pl.waw.ipipan.corpcor.server.pq.client.api.PQCQueryException;
import pl.waw.ipipan.corpcor.server.pq.client.lifecycle.PQCRequestHandlerPool;
import pl.waw.ipipan.corpcor.server.pq.client.lifecycle.PQRequestException;
import pl.waw.ipipan.corpcor.server.pq.client.tickets.PQCRequestTicket;
import pl.waw.ipipan.corpcor.server.pq.common.PQObjectFactory;
import pl.waw.ipipan.corpcor.server.pq.server.lifecycle.PQLMConfig;
import pl.waw.ipipan.corpcor.server.pq.server.lifecycle.PQLMPool;
import pl.waw.ipipan.corpcor.shared.pq.PoliqarpException;

/**
 * @author Nestor Pawlowski
 */
public class PQBridge {

    private static final Logger LOG = LoggerFactory.getLogger(PQBridge.class);
    private static PQBridge instance = null;

    public static synchronized PQBridge getInstance() {
        if (instance == null) {
            instance = new PQBridge();
        }
        return instance;
    }

    private PQCRequestHandlerPool pool;

    private PQBridge() {
        PQLMConfig lmConfig = PQObjectFactory.createLifecycleConfig();
        try {
            PQLMPool serverPool = new PQLMPool(lmConfig);
            pool = new PQCRequestHandlerPool(lmConfig, serverPool);
        } catch (Exception e) {
            LOG.error("failed to initialize PQBridge", e);
        }
    }
    
    public void forwardRequest(String clientId, PQCRequestTicket<?> ticket) throws PoliqarpException {
        try {
            pool.request(clientId, ticket);
        } catch (PQRequestException e) {
            ticket.setFailedResult();
            throw new PoliqarpException(e, "Błąd serwera podczas przetwarzania zapytania: " + e.getLocalizedMessage());
        } catch (PQCQueryException e) {
            ticket.setFailedResult();
            throw new PoliqarpException(e, "Błąd w zapytaniu: " + e.getLocalizedMessage());
        }
    }

    public void forwardSessionClose(String clientId) {
        PQBridge.getInstance().pool.closeSession(clientId);
    }

    public void forwardShutdown() {
        PQBridge.getInstance().pool.shutdown();
    }
}
