/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.api.common_1_3_12;

import ipipan.poliqarp.gui.Configuration;

import java.util.ResourceBundle;
import java.util.concurrent.Executor;

import pl.waw.ipipan.corpcor.server.pq.client.api.PQCConfig;
import pl.waw.ipipan.corpcor.server.pq.client.api.PQCRequestHandler;
import pl.waw.ipipan.corpcor.server.pq.common.AbstractPQObject;
import pl.waw.ipipan.corpcor.server.pq.server.lifecycle.PQDConnectionSlot;

public class Config extends AbstractPQObject implements PQCConfig {

    private String corpusImage;
    private int wideContext;
    private int leftContext;
    private int rightContext;

    public Config() {
        // keep no arg
    }
    
    @Override
    public String getCompatibleVersion() {
        return Constants.PQ_VERSION;
    }

    @Override
    public void initialize(ResourceBundle resources) {
        corpusImage = resources.getString(Constants.CORPUS_IMAGE_PROP_NAME);
        wideContext = Integer.valueOf(resources.getString(Configuration.OPT_WC));
        leftContext = Integer.valueOf(resources.getString(Configuration.OPT_LC));
        rightContext = Integer.valueOf(resources.getString(Configuration.OPT_RC));
    }

    @Override
    public PQCRequestHandler newRequestHandler(Executor executor, PQDConnectionSlot connInfo) {
        Configuration config = new Configuration();
        config.addConfigItem(Configuration.OPT_SERVER, connInfo.getHostname());
        config.addConfigItem(Configuration.OPT_PORT, String.valueOf(connInfo.getPort()));
        config.addConfigItem(Configuration.OPT_LC, String.valueOf(this.leftContext));
        config.addConfigItem(Configuration.OPT_RC, String.valueOf(this.rightContext));
        config.addConfigItem(Configuration.OPT_WC, String.valueOf(this.wideContext));
        config.addConfigItem(Configuration.OPT_DISPORTH, "yes");
        config.addConfigItem(Configuration.OPT_DISPBASE, "no");
        config.addConfigItem(Configuration.OPT_DISPTAG, "no");
        config.addConfigItem(Configuration.OPT_DISPORTHCONTEXT, "yes");
        config.addConfigItem(Configuration.OPT_DISPBASECONTEXT, "no");
        config.addConfigItem(Configuration.OPT_DISPTAGCONTEXT, "no");
        config.setMissingToDefault();
        return new RequestHandler(executor, config, this.corpusImage, connInfo.getId());
    }
}
