/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.lifecycle;

import pl.waw.ipipan.corpcor.server.pq.client.tickets.PQCRequestTicket;

public class PQRequestException extends Exception {
    private static final long serialVersionUID = 1L;

    public PQRequestException(String clientId, PQCRequestTicket<?> ticket, Exception e) {
        super("Result of " + ticket + " not acquired for " + clientId + " due to exception", e);
    }

    public PQRequestException(String clientId, PQCRequestTicket<?> ticket, String reason) {
        super("Result of " + ticket + " not acquired for " + clientId + " due to:" + reason);
    }
}
