/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.tickets;

import pl.waw.ipipan.corpcor.shared.pq.PoliqarpContext;

public class ContextTicket extends PQCRequestTicket<PoliqarpContext> {

    private final int queryResultId;

    public ContextTicket(int queryResultId) {
        super(TicketType.WIDECONTEXT);
        if (queryResultId < 0)
            throw new IllegalArgumentException("queryResultId < 0");
        this.queryResultId = queryResultId;
    }

    @Override
    protected PoliqarpContext createFailedResult() {
        return new PoliqarpContext();
    }
    
    public int getQueryResultId() {
        return queryResultId;
    }

    @Override
    public String toString() {
        return getType() + " at " + this.queryResultId;
    }
    
    @Override
    public ContextTicket createClone() {
        return new ContextTicket(queryResultId);
    }
}
