/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.client.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class PQDUtil {

    public static boolean tryConnect(String host, int port, int timeout, int attempts) {
        for (int i = 0; i < attempts; i++) {
            Socket s = new Socket();
            long start = System.currentTimeMillis();
            try {
                s.setSoTimeout(timeout);
                s.connect(new InetSocketAddress(host, port), timeout);
                return true;
            } catch (IOException e) {
                long delta = System.currentTimeMillis() - start;
                try {
                    if (delta < timeout)
                    Thread.sleep(timeout - delta);
                } catch (InterruptedException e1) {
                    return false;
                }
            } finally {
                try {
                    s.close();
                } catch (Exception e) {
                }
            }
        }
        return false;
    }
}
