/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.server.daemon;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import pl.waw.ipipan.corpcor.server.pq.common.PQObjectFactory;
import pl.waw.ipipan.corpcor.server.pq.server.PQUtil;

public class PQDConfig implements Cloneable {

    private static final Logger LOG = LoggerFactory.getLogger(PQDConfig.class);

    private String id;

    private final Map<String, String> pqdConfigMap = new HashMap<String, String>();

    private PQDConfig(PQDConfig c) {
        this.pqdConfigMap.putAll(c.pqdConfigMap);
        this.id = String.valueOf(Math.abs((long) PQUtil.random.nextInt()));
    }

    public PQDConfig(ResourceBundle bundle) {
        LOG.debug("Create for bundle " + bundle);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            try {
                pqdConfigMap.put(key, bundle.getString(key));
            } catch (Exception e) {
                LOG.error("Problem with bundle. Value " + key, e);
                continue;
            }
        }
        this.id = String.valueOf(Math.abs((long) PQUtil.random.nextInt()));
    }

    public PQDConfig(String bundleName) {
        this(ResourceBundle.getBundle(bundleName));
    }

    @Override
    public PQDConfig clone() {
        return new PQDConfig(this);
    }

    public PQDConfigurator createConfigurator(String platform, String version) {
        LOG.debug("Create new configurator for " + platform + "/" + version);
        PQDConfigurator configurator;
        try {
            configurator = PQObjectFactory.createDaemonConfigurator(platform, version);
        } catch (ClassNotFoundException e) {
            LOG.error("Cannot create configurator", e);
            return null;
        }
        return configurator;
    }

    public String getId() {
        return id;
    }

    public Map<String, String> getPqdConfig() {
        return pqdConfigMap;
    }

    public void setId(String id) {
        this.id = id;
    }
}
