/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.server.daemon.common_1_3_12;

import java.io.File;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import pl.waw.ipipan.corpcor.server.pq.common.AbstractPQObject;
import pl.waw.ipipan.corpcor.server.pq.common.PQObjectFactory;
import pl.waw.ipipan.corpcor.server.pq.server.PQUtil;
import pl.waw.ipipan.corpcor.server.pq.server.daemon.PQDDeployment;
import pl.waw.ipipan.corpcor.server.pq.server.daemon.PQDInstaller;
import pl.waw.ipipan.corpcor.server.pq.server.lifecycle.PQLMConfig;

public abstract class AbstractInstaller extends AbstractPQObject implements PQDInstaller {

    protected static final Logger LOG = LoggerFactory.getLogger(AbstractInstaller.class);

    protected static Runnable createCleanup(final File deploymentDir) {
        return new Runnable() {

            @Override
            public void run() {
                try {
                    LOG.info("Trying to cleanup " + deploymentDir);
                    if (deploymentDir != null) {
                        File[] listFiles = deploymentDir.listFiles();
                        for (int i = 0; i < listFiles.length; i++) {
                            boolean delete = listFiles[i].delete();
                            LOG.debug("Removing file " + listFiles[i] + ": " + delete);
                        }
                    }
                    deploymentDir.delete();
                } catch (Exception e) {
                    LOG.warn("Cannot cleanup " + this, e);
                }
            }
        };
    }

    @Override
    public PQDDeployment deploy(PQLMConfig lmConfig) throws IOException {
        LOG.debug("Deploying " + this);
        File deploymentDir;
        deploymentDir = new File(lmConfig.getDeploymentRootDir(), "pqd-" + getInitializedPlatform() + "-"
                + getInitializedVersion());
        if (!deploymentDir.exists()) {
            if (!deploymentDir.mkdir())
                throw new IOException("Failed to create installation directory " + deploymentDir);
        }
        Runnable cleanup = lmConfig.isDeleteDeploymentOnExit() ? createCleanup(deploymentDir) : null;
        try {
            File executableFile = deployFile(deploymentDir, getExecutableName());
            executableFile.setExecutable(true);
            String[] fnames = getAdditionalFileNames();
            for (int i = 0; i < fnames.length; i++) {
                deployFile(deploymentDir, fnames[i]);
            }
            return PQObjectFactory.createDaemonDeployment(getInitializedPlatform(), getInitializedVersion(), deploymentDir,
                    executableFile, cleanup);
        } catch (IOException e) {
            LOG.debug("Deployment failed, cleaning up: " + this);
            if (cleanup != null)
                cleanup.run();
            throw e;
        } catch (ClassNotFoundException e) {
            LOG.error("No pq deployment handler found", e);
            return null;
        }
    }
    
    protected abstract String getExecutableName();

    protected abstract String[] getAdditionalFileNames();

    protected File deployFile(File dir, String fName) throws IOException {
        return PQUtil.deployResource(this.getClass().getResource(fName), dir, fName);
    }
}
