/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.server.pq.server.daemon.common_1_3_12;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface Constants {

    public static final String PQ_VERSION = "poliqarpd version 1.3.12 (compiled with sakura library, version 1.3.12)";

    public static final String CONF_HOSTNAME = "hostname";
    public static final String CONF_PORT = "port";
    public static final String CONF_LOGGING = "logging";
    public static final String CONF_LOG_FILE = "log-file";
    public static final String CONF_MATCH_BUFFER_SIZE = "match-buffer-size";
    public static final String CONF_MAX_MATCH_LENGHT = "max-match-length";
    public static final String CONF_MAX_SESSION_IDLE = "max-session-idle";
    public static final String CONF_CORPUS = "corpus";

    public static final Set<String> SUPPORTED_CONF_OPTIONS = new HashSet<String>(Arrays.asList(CONF_CORPUS,
            CONF_HOSTNAME, CONF_LOG_FILE, CONF_LOGGING, CONF_MATCH_BUFFER_SIZE, CONF_MAX_MATCH_LENGHT,
            CONF_MAX_SESSION_IDLE, CONF_PORT));

    public static final String ECONF_MAX_CONNECTIONS = "pqd.max-connections";

    public static final String ARG_CONFIG_FILE = "--config-file";
    public static final String ARG_VERSION = "--version";

    public static final String CMD_PING = "PING";
    public static final String CMD_HALT = "HALT";
    public static final String CMD_MAKESESSION = "MAKE-SESSION";
    public static final String CMD_CLOSESESSION = "CLOSE-SESSION";

    public static final String RESP_PONG = "PONG";

    public static final int CONST_PING_TIMEOUT = 3000;
}
