/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.shared.pq;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PoliqarpMetaData implements Serializable {

    private static final long serialVersionUID = 1L;

    private HashMap<String, String[]> tags = new HashMap<String, String[]>();

    public String[] getMetadataValues(String metadataKey) {
        return tags.get(metadataKey);
    }

    public String[] setMetadataValues(String metadataKey, String[] values) {
        return tags.put(metadataKey, values);
    }

    public Set<String> getMetadataKeySet() {
        return new HashSet<String>(tags.keySet());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = tags.keySet();
        for (String key : keySet) {
            String[] values = tags.get(key);
            if (values == null || values.length == 0)
                continue;
            sb.append(key);
            sb.append(": [");
            for (int i = 0; i < values.length; i++) {
                sb.append(values[i]);
                if (i < values.length - 1)
                    sb.append("; ");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }
}
