/*
 * This file is part of the CorpCor suite.
 * 
 * Copyright (C) 2012 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact 
 * ipi@ipipan.waw.pl for more information).  Licensees holding a valid 
 * commercial license from IPI PAN may use this file in accordance with 
 * that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package pl.waw.ipipan.corpcor.shared.pq;

import java.io.Serializable;

public class PoliqarpSegment implements Serializable {
    private static final long serialVersionUID = 1L;
    
    private String word;
    private String lem;
    private String tag;
    
    public PoliqarpSegment() {
        this("", "", "");
    }
    
    public PoliqarpSegment(String word, String lem, String tag) {
        this.word = word;
        this.lem = lem;
        this.tag = tag;
    }

    public String getWord() {
        return word;
    }

    public String getLem() {
        return lem;
    }

    public String getTag() {
        return tag;
    }
}
