package pl.waw.ipipan.corpcor.shared.validation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MsdCtagRules {
	public final static HashMap<String, List<String>> attrMap = new HashMap<String, List<String>>() {{
		put("number", Arrays.asList(new String[] {"sg", "pl"}));
		put("case", Arrays.asList(new String[] {"nom", "gen", "dat", "acc", "inst", "loc", "voc"}));
		put("gender", Arrays.asList(new String[] {"m1", "m2", "m3", "f", "n"}));
		put("person", Arrays.asList(new String[] {"pri", "sec", "ter"}));
		put("degree", Arrays.asList(new String[] {"pos", "com", "sup"}));
		put("aspect", Arrays.asList(new String[] {"imperf", "perf"}));
		put("negation", Arrays.asList(new String[] {"aff", "neg"}));
		put("accommodability", Arrays.asList(new String[] {"congr", "rec"}));
		put("accentability", Arrays.asList(new String[] {"akc", "nakc"}));
		put("post-prepositionality", Arrays.asList(new String[] {"npraep", "praep"}));
		put("agglutination", Arrays.asList(new String[] {"agl", "nagl"}));
		put("vocalicity", Arrays.asList(new String[] {"nwok", "wok"}));
		put("fullstoppedness", Arrays.asList(new String[] {"pun", "npun"}));
	}};
	
	public final static HashMap<String, List<String>> posMap = new HashMap<String, List<String>>() {{
		put("adja", Arrays.asList(new String[] {}));
		put("adjp", Arrays.asList(new String[] {}));
		put("adjc", Arrays.asList(new String[] {}));
		put("conj", Arrays.asList(new String[] {}));
		put("comp", Arrays.asList(new String[] {}));
		put("interp", Arrays.asList(new String[] {}));
		put("pred", Arrays.asList(new String[] {}));
		put("xxx", Arrays.asList(new String[] {}));
		put("adv", Arrays.asList(new String[] {"[degree]"}));
		put("imps", Arrays.asList(new String[] {"aspect"}));
		put("inf", Arrays.asList(new String[] {"aspect"}));
		put("pant", Arrays.asList(new String[] {"aspect"}));
		put("pcon", Arrays.asList(new String[] {"aspect"}));
		put("qub", Arrays.asList(new String[] {"[vocalicity]"}));
		put("prep", Arrays.asList(new String[] {"case", "[vocalicity]"}));
		put("siebie", Arrays.asList(new String[] {"case"}));
		put("subst", Arrays.asList(new String[] {"number", "case", "gender"}));
		put("depr", Arrays.asList(new String[] {"number", "case", "gender"}));
		put("ger", Arrays.asList(new String[] {"number", "case", "gender", "aspect", "negation"}));
		put("ppron12", Arrays.asList(new String[] {"number", "case", "gender", "person", "[accentability]"}));
		put("ppron3", Arrays.asList(new String[] {"number", "case", "gender", "person", "accentability", "post-prepositionality"}));
		put("num", Arrays.asList(new String[] {"number", "case", "gender", "accommodability"}));
		put("numcol", Arrays.asList(new String[] {"number", "case", "gender", "accommodability"}));
		put("adj", Arrays.asList(new String[] {"number", "case", "gender", "degree"}));
		put("pact", Arrays.asList(new String[] {"number", "case", "gender", "aspect", "negation"}));
		put("ppas", Arrays.asList(new String[] {"number", "case", "gender", "aspect", "negation"}));
		put("winien", Arrays.asList(new String[] {"number", "gender", "aspect"}));
		put("praet", Arrays.asList(new String[] {"number", "gender", "aspect", "[agglutination]"}));
		put("bedzie", Arrays.asList(new String[] {"number", "person", "aspect"}));
		put("fin", Arrays.asList(new String[] {"number", "person", "aspect"}));
		put("impt", Arrays.asList(new String[] {"number", "person", "aspect"}));
		put("aglt", Arrays.asList(new String[] {"number", "person", "aspect", "vocalicity"}));
		put("brev", Arrays.asList(new String[] {"fullstoppedness"}));
		put("burk", Arrays.asList(new String[] {}));
		put("interj", Arrays.asList(new String[] {}));
	}};
	
	protected MsdCtagRules() {}
}
