package pl.waw.ipipan.corpcor.shared.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import pl.waw.ipipan.corpcor.shared.AnnotationValidation;

import com.google.common.base.Splitter;
import com.google.gwt.user.client.ui.HasText;

public class MsdCtagValidator implements ConstraintValidator<ValidMsdCtag, AnnotationValidation> {

	private ValidMsdCtag constraintAnnotation;

	@Override
	public void initialize(ValidMsdCtag constraintAnnotation) {
		this.constraintAnnotation = constraintAnnotation;
	}

	@Override
	public boolean isValid(AnnotationValidation value,
			ConstraintValidatorContext context) {
		Map<String, String> annot = new HashMap<String, String>();
		
		String m = value.getMsd();
		String c = value.getCtag();
		
		List<String> posAttrs = MsdCtagRules.posMap.get(c);
		if (posAttrs == null) {
//			return "Nieprawidłowa wartość CTAG";
			return false;
		}
		
		Iterable<String> splitted = Splitter.on(":").split(m);
		int i = 0;
		for (String s : splitted) {
			if (i >= posAttrs.size()) {
				if (m.length() > 0) {
//					return "Nieprawidłowa wartość POS: " + s;
					return false;
				} else {
					continue;
				}
			}
			
			String posAttr = posAttrs.get(i);
			boolean optional = false;
			if (posAttr.startsWith("[")) {
				posAttr = posAttr.substring(1, posAttr.length() - 1);
				optional = true;
			}
			
			List<String> attrs = MsdCtagRules.attrMap.get(posAttr);
			
			if (s.length() == 0) {
				if (m.length() > 0) {
					// Pusty fragment w dłuższym napisie
					return false;
				} else {
					// Pusty napis - OK tylko dla pojedynczego opcjonalnego atrybutu lub gdy nie ma żadnych atrybutów
					if (optional == false) {
						if (!attrs.contains(s)) {
							return false;
						}
					}
				}
			} else {				
				if (!attrs.contains(s)) {
	//				return "Nieprawidłowa wartość POS: " + s;
					return false;
				}
			}
			
			annot.put(posAttr, s);
			
			i++;
		}
		
		if (i < posAttrs.size()) {
			if (!posAttrs.get(i).startsWith("[")) {
//				return "Brakująca wartość POS: " + posAttrs.get(i);
				return false;
			}
		}
		
		/* number:case:gender:person */
		if ("ppron12".equals(c)) {
			if (annot.get(posAttrs.get(0)).equals("sg") && (
					(annot.get(posAttrs.get(1)).equals("dat") && annot.get(posAttrs.get(3)).equals("pri")) 
					|| (annot.get(posAttrs.get(1)).equals("gen") && annot.get(posAttrs.get(3)).equals("sec")) 
					|| (annot.get(posAttrs.get(1)).equals("dat") && annot.get(posAttrs.get(3)).equals("sec"))
					|| (annot.get(posAttrs.get(1)).equals("acc") && annot.get(posAttrs.get(3)).equals("sec"))
					|| (annot.get(posAttrs.get(1)).equals("gen") && annot.get(posAttrs.get(3)).equals("pri"))
					)) {

				if (annot.get("accentability") == null) {
					return false;
				}
			} else {
				if (annot.get("accentability") != null) {
					return false;
				}
			}
		}
		
		if ("ppron3".equals(c)) {
			/*
			if (annot.get("accentability") == null) {
				return false;
			}*/
			
			if (m.startsWith("sg:gen:m1") || m.startsWith("sg:dat:m1") || m.startsWith("sg:acc:m1")
					|| m.startsWith("sg:gen:m2") || m.startsWith("sg:dat:m2")
					|| m.startsWith("sg:acc:m2") || m.startsWith("sg:gen:m3") || m.startsWith("sg:dat:m3")
					|| m.startsWith("sg:acc:m3") || m.startsWith("sg:gen:n") || m.startsWith("sg:dat:n")) {
				// Nothing here
			} else {
				if (!annot.get("accentability").equals("akc")) {
					return false;
				}
			}
		}
		
		return true;
	}

}
