/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.connection;

/**
 * Interface for objects whose state can be asynchronously changed via a
 * message from the server.
 */
public interface AsyncHandler
{
   /** 
    * Handles an asynchronous message.
    *
    * An asynchronous message is one that can be sent by a server at any time.
    * When such a message is received by a connection's message handling
    * thread, it calls this method of its current message handler. Because
    * this is done by a thread other that the one normally using this object,
    * any operations that need atomicity for the data potentially handled by
    * this method should be synchronized on the implementing object. However,
    * this method itself need not be synchronized: this is done by the 
    * message handling thread.
    *
    * @param message the message to be handled
    */
   public void handle(String message);
}
