/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

/**
 * Some rudimentary statistics of a corpus. The statistics include
 * number of segments in the corpus, number of types of segments
 * (aka orthographic forms), number of lemmata and number of tags.
 */
public final class CorpusStatistics
{
   private int numSegments;
   private int numTypes;
   private int numLemmata;
   private int numTags;

   CorpusStatistics(int numSegments, int numTypes, int numLemmata, 
      int numTags)
   {
      this.numSegments = numSegments;
      this.numTypes = numTypes;
      this.numLemmata = numLemmata;
      this.numTags = numTags;
   }

   /**
    * Returns number of segments in the corpus.
    */
   public int getSegments()
   {
      return numSegments;
   }

   /**
    * Returns number of types of segments (number of distinct orthographic
    * forms) in the corpus.
    */
   public int getTypes()
   {
      return numTypes;
   }

   /**
    * Returns number of types of lemmata (base forms) in the corpus.
    */
   public int getLemmata()
   {
      return numLemmata;
   }

   /**
    * Returns number of types of tags in the corpus.
    */
   public int getTags()
   {
      return numTags;
   }
}  
