/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.io.IOException;
import java.util.Map;
import java.util.EnumMap;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.results.*;

/**
 * The <code>Match</code> class models a result of the query.
 */
public final class Match 
{
   private ResultCell[] match;
   private Query query;

   /**
    * Constructs a <code>Match</code> for a given query, reading its 
    * description from a connection.
    * 
    * @throws IOException if an I/O exception occurred
    */
   public Match(Query query, PoliqarpConnection connection) throws IOException
   {
      this.query = query;
      ColumnType[] header = query.getHeader();
      match = new ResultCell[header.length];
      int i = 0;
      for (ColumnType col : header) {
         match[i++] = col.readCell(connection);
      }
   }

   /**
    * Constructs a <code>Match</code> from a ResultCell array.  Used
    * to make the statistical results appear similar to matches, to
    * fool the ResultWriter.
    */
   public Match(ResultCell[] line) {
      match = line;
   }

   /**
    * Returns the given column of this match.
    *
    * @param col zero-based number of the column
    */
   public ResultCell getCell(int col)
   {
      return match[col];
   }

   /**
    * Returns left match - ugly, FIXME
    */
   public Segment[] getLeftMatch() {
      return match.length == 3 ? null : ((MatchCell) match[1]).getSegments();
   }

   /**
    * Returns right match - ugly, FIXME
    */
   public Segment[] getRightMatch() {
      return ((MatchCell) match[match.length == 3 ? 1 : 2]).getSegments();
   }
}
