/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.io.IOException;
import java.util.Iterator;

import ipipan.poliqarp.connection.PoliqarpConnection;

/**
 * Iterator over all results of an executed query. 
 *
 * This iterator makes a GET-RESULTS request to the server and reads all
 * results of a query, independently of the state of <code>MatchList</code>.
 * It requires that all results be read from it (i.e. the reading cannot be
 * interrupted in the middle).
 */
public final class MatchIterator implements Iterator<Match>
{
   int number, count;
   PoliqarpConnection connection;
   Query query;

   MatchIterator(PoliqarpConnection connection, Query query, int count)
   {
      this.connection = connection;
      this.query = query;
      this.count = count;
      this.number = 0;
      try { 
         connection.send("GET-RESULTS 0 " + (this.count - 1));
         connection.getMessage();
      } catch (IOException e) {
         System.err.println("MatchIterator creation failure");
      }
   }

   /** 
    * Answers whether there are matches left in this iterator.
    */   
   public boolean hasNext() 
   {
      return number < count;
   }

   /**
    * Returns the next match.
    */
   public Match next()
   {
      number++;
      try {
         return new Match(query, connection);
      } catch (IOException e) {
         return null;
      }
   }

   /**
    * Always throws <code>UnsupportedOperationException</code>, since this
    * iterator doesn't support removing elements.
    */
   public void remove() throws UnsupportedOperationException
   {
      throw new UnsupportedOperationException();
   }
}
