/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic;

import java.io.IOException;
import java.util.*;

import ipipan.poliqarp.connection.PoliqarpConnection;

/**
 * The set of metadata for a query result. It may be viewed as a map
 * from strings to metadata values, and is in fact implemented thusly,
 * with the exception that it is able to create itself reading its
 * description from a connection.
 */
public final class MetaData extends HashMap<String, List<MetaDataValue> >
{
   /**
    * Types of metadata.
    */
   public enum Type {
      /**
       * Textual metadata.
       */
      TEXT,

      /**
       * Metadata holding a date.
       */
      DATE
   };

   /**
    * Constructs this set of metadata, reading its description from
    * a connection.
    * @param connection the connection to read the metadata from
    * @param num number of items in this set of metadata.
    */
   public MetaData(PoliqarpConnection connection, int num)
      throws IOException
   {
      super();
      for (int i = 0; i < num; i++) {
         String key = connection.getMessage().toString();
         MetaDataValue value = MetaDataValue.readFromConnection(connection);
         List<MetaDataValue> vals = get(key);
         if (vals == null) {
            vals = new LinkedList<MetaDataValue>();
            put(key, vals);
         }
         vals.add(value);
      }
   }
}
