/*
 * This file is part of the Poliqarp suite.
 * 
 * Copyright (C) 2004-2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 * 
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file gpl.txt included in the packaging
 * of this file.  (See http://www.gnu.org/licenses/translations.html for
 * unofficial translations.)
 * 
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package ipipan.poliqarp.logic.results;

import ipipan.poliqarp.connection.PoliqarpConnection;

public abstract class ColumnType
{
   public String getName()
   {
      return "";
   }

   public static final ColumnType parseColumn(String description)
      throws InvalidColumnException
   {
      int descStart = description.indexOf("<"),
         descEnd = description.indexOf(">");
      if (descStart == -1 || descEnd == -1)
         throw new InvalidColumnException();
      String
         colType = description.substring(0, descStart),
         colParams = description.substring(descStart + 1, descEnd);
      
      // this pseudo-switch is somewhat ugly, but will do for now
      if (colType.equals("LC")) 
         return new ColumnLeftContext(colParams);
      else if (colType.equals("LM")) 
         return new ColumnLeftMatch(colParams);
      else if (colType.equals("M"))
         return new ColumnWholeMatch(colParams);
      else if (colType.equals("RM"))
         return new ColumnRightMatch(colParams);
      else if (colType.equals("RC"))
         return new ColumnRightContext(colParams);
      else {
         throw new InvalidColumnException();
      }
   }

   public abstract ResultCell readCell(PoliqarpConnection connection)
      throws java.io.IOException;
}
