package ipipan.poliqarp.stat;

import java.text.NumberFormat;
import java.text.DecimalFormat;

import ipipan.poliqarp.logic.Match;

public class MatchCount {
   private MatchCount left, right;
   private String match;
   private int count;
   private float   cp     = 0;
   private boolean cpCalc = false;
   private int matchRef;

   private static final NumberFormat format = new DecimalFormat("0.000");

   // FIXME - should not be necessary at all
   private static final StatCell emptyCell = new StatCell("");

   public MatchCount(String m, int mr) {
      left  = null;
      right = null;
      count = 1;
      match = m;
      matchRef = mr;
   }

   public MatchCount(String m, MatchCount l, MatchCount r, int mr) {
      left  = l;
      right = r;
      count = 1;
      match = m;
      matchRef = mr;
   }

   public void inc() {
      count ++;
   }

   public String getMatch() {
      return match;
   }

   public int getMatchRef() {
      return matchRef;
   }

   public float getCp(CTest test) {
      if (cpCalc || left == null)
         return cp;

      cp = test.calc(left.count, right.count, count);
      cpCalc = true;
      return cp;
   }

   public int getCount() {
      return count;
   }

   public String toString() {
      String res = count + "\t" + match;
      if (left != null)
         res = left.getCount()+"\t"+right.getCount()+"\t" + res;
      if (cpCalc)
         res = format.format(cp) + "\t" + res;
      return res;
   }

   public String[] toStringArray()
   {
      String[] res = null;
      if (left == null) {
         res = new String[2];
         res[0] = match;
         res[1] = String.valueOf(getCount());
         return res;
      }
      res = new String[cpCalc ? 6 : 5];
      res[0] = left.getMatch();
      res[1] = right.getMatch();
      res[2] = String.valueOf(left.getCount());
      res[3] = String.valueOf(right.getCount());
      res[4] = String.valueOf(getCount());
      if (cpCalc) {
         res[5] = format.format(cp);
      }
      return res;
   }

   public StatCell[] toCellArray()
   {
      StatCell[] res = null;
      if (left == null) {
         res = new StatCell[2];
         res[0] = new StatCell(match);
         res[1] = new StatCell(getCount());
         return res;
      }
      res = new StatCell[cpCalc ? 6 : 5];
      res[0] = new StatCell(left.getMatch());
      res[1] = new StatCell(right.getMatch());
      res[2] = new StatCell(left.getCount());
      res[3] = new StatCell(right.getCount());
      res[4] = new StatCell(getCount());
      if (cpCalc) {
         res[5] = new StatCell(cp);
      }
      return res;
   }
}
