package ipipan.poliqarp.stat;

import java.util.Comparator;

public class MatchCountGuiComparator implements Comparator<MatchCount>
{
   private int column;
   private boolean ascending;

   public MatchCountGuiComparator(int column, boolean ascending)
   {
      this.column = column;
      this.ascending = ascending;
   }

   public int compare(MatchCount arg0, MatchCount arg1)
   {
      int retval = 0;
      StatCell[]
         cells0 = arg0.toCellArray(),
         cells1 = arg1.toCellArray();
      switch (cells0[column].kind) {
         case StatCell.TEXT:
            retval = cells0[column].txt.compareTo(cells1[column].txt);
            break;
         case StatCell.INTEGER:
            retval = cells1[column].val - cells0[column].val;
            break;
         case StatCell.FLOAT:
            retval = Float.compare(cells1[column].fval, cells0[column].fval);
            break;
      }
      if (!ascending)
         retval = -retval;
      return retval;
   }
}
